function Plotter(x, y, fignum, SubP, format, ttl, xlbl, ylbl, grd, zm, hld)

% This function plots a 2-D graph of the data in vectors x and y
% Figure preferences are given in the function's parameters
% Note: subp is a 1x3 vector which defines the subplot parameters

% Example:
% Plotter(x, y, 3, SP, 'r.', 'Example Graph', 'X-axis', 'Y-axis', 'on', 'on', 'off');
% where SP = [2, 1, 2],
% will plot y vs. x in the bottom half of figure 3 using red dots, with "Example Graph" 
% as the title, "X-axis" as the xlabel, "Y-axis" as the ylabel, grid on, 
% zoom on, and hold off

figure(fignum);
if nargin >= 11
    eval(['hold ', hld]);
end
subplot(SubP(1), SubP(2), SubP(3)), plot(x, y, format);
if nargin >= 6
    title(ttl);
end
if nargin >= 7
    xlabel(xlbl);
end
if nargin >= 8
    ylabel(ylbl);
end
if nargin >= 9
    eval(['grid ', grd]);
end
if nargin >= 10
    eval(['zoom ', zm]);
end
